/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import ppe.StateChangeListener;
import ppe.UtilPPE;
import ppe.ec2.InstanceStatus;
import ppe.ec2.NetworkInfo;
import ppe.ec2.NiM;

public class NetworkTableModel
extends AbstractTableModel
implements StateChangeListener {
    @Override
    public int getRowCount() {
        return NiM.getNetworks().size();
    }

    @Override
    public int getColumnCount() {
        return NtColumn.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return NtColumn.values()[column].nm;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<NetworkInfo> nis = NiM.getNetworks();
        if (nis.size() < rowIndex + 1) {
            return "-";
        }
        NetworkInfo ni = nis.get(rowIndex);
        int nInstances = ni.instances.size();
        InstanceStatus ins0 = null;
        if (nInstances > 0) {
            ins0 = ni.instances.get(0);
        }
        NtColumn col = NtColumn.values()[columnIndex];
        switch (col) {
            case networkName: {
                return ni.getNetworkName();
            }
            case status: {
                return ni.getStateDescription();
            }
            case nInstances: {
                return Integer.toString(nInstances);
            }
            case launchTime: {
                long lt = ni.getLaunchTime();
                if (lt < Long.MAX_VALUE) {
                    return UtilPPE.toDateTimeString(lt);
                }
                return "null";
            }
            case securityGroup: {
                if (ins0 != null) {
                    return UtilPPE.toCsv(ins0.securityGroupNames);
                }
                return " ";
            }
            case rsaKeyname: {
                if (ins0 != null) {
                    return ins0.instance.getKeyName();
                }
                return " ";
            }
            case virtualizationType: {
                if (ins0 != null) {
                    return ins0.instance.getVirtualizationType();
                }
                return " ";
            }
        }
        return "Undefined column: " + (col != null ? col.toString() : "null");
    }

    @Override
    public void stateChanged() {
        this.fireTableDataChanged();
    }

    public int getNetworkNameColumnIndex() {
        for (int i = 0; i < NtColumn.values().length; ++i) {
            if (!NtColumn.values()[i].equals((Object)NtColumn.networkName)) continue;
            return i;
        }
        return -1;
    }

    private static enum NtColumn {
        networkName("Network name"),
        status("Status"),
        nInstances("N ec2 instances"),
        launchTime("Launch time"),
        securityGroup("Security group"),
        rsaKeyname("RSA key name"),
        virtualizationType("Virtualization");

        String nm;

        private NtColumn(String nm) {
            this.nm = nm;
        }
    }
}

