% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/week-year-week-day.R
\name{as_year_week_day}
\alias{as_year_week_day}
\title{Convert to year-week-day}
\usage{
as_year_week_day(x, ..., start = NULL)
}
\arguments{
\item{x}{\verb{[vector]}

A vector to convert to year-week-day.}

\item{...}{These dots are for future extensions and must be empty.}

\item{start}{\verb{[integer(1) / NULL]}

The day to consider the start of the week. 1 = Sunday and 7 = Saturday.

If \code{NULL}:
\itemize{
\item If \code{x} is a year-week-day, it will be returned as is.
\item Otherwise, a \code{start} of Sunday will be used.
}}
}
\value{
A year-week-day vector.
}
\description{
\code{as_year_week_day()} converts a vector to the year-week-day
calendar. Time points, Dates, POSIXct, and other calendars can all be
converted to year-week-day.
}
\examples{
# From Date
as_year_week_day(as.Date("2019-01-01"))
as_year_week_day(as.Date("2019-01-01"), start = clock_weekdays$monday)

# From POSIXct, which assumes that the naive time is what should be converted
as_year_week_day(as.POSIXct("2019-01-01 02:30:30", "America/New_York"))

# From other calendars
as_year_week_day(year_quarter_day(2019, quarter = 2, day = 50))
}
