% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{seq.clock_iso_year_week_day}
\alias{seq.clock_iso_year_week_day}
\title{Sequences: iso-year-week-day}
\usage{
\method{seq}{clock_iso_year_week_day}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from}{\verb{[clock_iso_year_week_day(1)]}

A \code{"year"} precision iso-year-week-day to start the sequence
from.

\code{from} is always included in the result.}

\item{to}{\verb{[clock_iso_year_week_day(1) / NULL]}

A \code{"year"} precision iso-year-week-day to stop the sequence
at.

\code{to} is cast to the type of \code{from}.

\code{to} is only included in the result if the resulting sequence divides
the distance between \code{from} and \code{to} exactly.}

\item{by}{\verb{[integer(1) / clock_duration(1) / NULL]}

The unit to increment the sequence by.

If \code{to < from}, then \code{by} must be positive.

If \code{to > from}, then \code{by} must be negative.

If \code{by} is an integer, it is transformed into a duration with the
precision of \code{from}.

If \code{by} is a duration, it is cast to the type of \code{from}.}

\item{length.out}{\verb{[positive integer(1) / NULL]}

The length of the resulting sequence.

If specified, \code{along.with} must be \code{NULL}.}

\item{along.with}{\verb{[vector / NULL]}

A vector who's length determines the length of the resulting sequence.

Equivalent to \code{length.out = vec_size(along.with)}.

If specified, \code{length.out} must be \code{NULL}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A sequence with the type of \code{from}.
}
\description{
This is a iso-year-week-day method for the \code{\link[=seq]{seq()}} generic.

Sequences can only be generated for \code{"year"} precision
iso-year-week-day vectors. If you need to generate week-based sequences,
you'll have to convert to a time point first.

When calling \code{seq()}, exactly two of the following must be specified:
\itemize{
\item \code{to}
\item \code{by}
\item Either \code{length.out} or \code{along.with}
}
}
\examples{
# Yearly sequence
x <- seq(iso_year_week_day(2020), iso_year_week_day(2026), by = 2)
x

# Which we can then set the week of.
# Some years have 53 ISO weeks, some have 52.
set_week(x, "last")
}
