% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{normal}
\alias{normal}
\title{Normal Distribution for Prior Specification}
\usage{
normal(mu = 0, sigma = 1)
}
\arguments{
\item{mu}{Mean of the normal distribution. Default: 0}

\item{sigma}{Standard deviation of the normal distribution. Must be positive. Default: 1}
}
\value{
An object of class \code{"clm_dist"} representing a normal distribution.
}
\description{
Creates a normal distribution object for use with \code{\link[=prior]{prior()}}.
}
\examples{
# Create a normal prior
normal(0, 2.5)

# Use with prior()
prior(normal(0, 2.5), class = "b")
}
\seealso{
\code{\link[=prior]{prior()}}, \code{\link[=gamma]{gamma()}}, \code{\link[=student_t]{student_t()}}, \code{\link[=cauchy]{cauchy()}}
}
