% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipboard.R
\name{write_clip}
\alias{write_clip}
\title{Write clipboard}
\usage{
write_clip(content, object_type = c("auto", "character", "table"),
  breaks = NULL, eos = NULL, return_new = TRUE,
  allow_non_interactive = Sys.getenv("CLIPR_ALLOW", interactive()), ...)
}
\arguments{
\item{content}{An object to be written to the system clipboard.}

\item{object_type}{write_clip() tries to be smart about writing objects in a
useful manner. If passed a data.frame or matrix, it will format it using
\code{\link{write.table}} for pasting into an external spreadsheet program.
It will otherwise coerce the object to a character vector. \code{auto} will
check the object type, otherwise \code{table} or \code{character} can be
explicitly specified.}

\item{breaks}{The separator to be used between each element of the character
vector being written. \code{NULL} defaults to writing system-specific line
breaks between each element of a character vector, or each row of a table.}

\item{eos}{The terminator to be written after each string, followed by an
ASCII \code{nul}. Defaults to no terminator character, indicated by
\code{NULL}.}

\item{return_new}{If true, returns the rendered string; if false, returns the
original object}

\item{allow_non_interactive}{By default, clipr will throw an error if run in
a non-interactive session. Set the environment variable
\code{CLIPR_ALLOW=TRUE} in order to override this behavior, however see the
advisory below before doing so.}

\item{...}{Custom options to be passed to \code{\link{write.table}} (if
\code{x} is a table-like). Defaults to sane line-break and tab standards
based on the operating system. By default \code{col.names = FALSE}, however
you may override this by passing \code{col.names = TRUE}.}
}
\value{
Invisibly returns the original object
}
\description{
Write a character vector to the system clipboard
}
\note{
On X11 systems, \code{write_clip} will cause either xclip (preferred)
  or xsel to be called. Be aware that, by design, these processes will fork
  into the background. They will run until the next paste event, when they
  will then exit silently. (See the man pages for
  \href{https://linux.die.net/man/1/xclip}{xclip} and
  \href{http://www.vergenet.net/~conrad/software/xsel/xsel.1x.html#notes}{xsel}
   for more on their behaviors.) However, this means that even if you
  terminate your R session after running \code{write_clip}, those processes
  will continue until you access the clipboard via another program. This may
  be expected behavior for interactive use, but is generally undesirable for
  non-interactive use. For this reason you must not run \code{write_clip} on
  CRAN, as the nature of xsel
  \href{https://github.com/mdlincoln/clipr/issues/38}{has caused issues in
  the past}.

  Call \code{\link{clipr_available}} to safely check whether the clipboard is
  readable and writable.
}
\examples{
\dontrun{
text <- "Write to clipboard"
write_clip(text)

multiline <- c("Write", "to", "clipboard")
write_clip(multiline)
# Write
# to
# clipboard

write_clip(multiline, breaks = ",")
# write,to,clipboard

tbl <- data.frame(a=c(1,2,3), b=c(4,5,6))
write_clip(tbl)
}

}
