#' Transforms Output of read_clip into data frame.
#'
#' Transforms clipped content into a data frame by putting
#' \code{\link{read_clip}} output by using \code{\link{read.table}}.
#'
#' @param x Defaults to reading from the clipboard, but can be substituted by a
#'   character vector already generated by \code{\link{read_clip}}.
#' @param \ldots Options to pass to \code{\link{read.table}}. The following
#'   \code{\link{read.table}} arguments will be passed by default, but can be
#'   overridden by specifying them when calling \code{read_clip_tbl}: \describe{
#'   \item{\code{header}}{\code{TRUE}} \item{\code{sep}}{\code{"\t"}}
#'   \item{\code{stringsAsFactors}}{\code{FALSE}}
#'   \item{\code{na.strings}}{\code{c("NA", "")}}
#'   \item{\code{strip.white}}{\code{TRUE}} }
#'
#' @return A data frame with the contents of the clipboard. If the system
#'   clipboard is empty, returns \code{NULL}
#'
#' @export
read_clip_tbl <- function(x = read_clip(), ...) {
  if(is.null(x))
    return(NULL)

  .dots <- list(...)
  .dots$file <- textConnection(paste0(x, collapse = "\n"))

  if(is.null(.dots$header))
    .dots$header <- TRUE
  if(is.null(.dots$sep))
    .dots$sep <- "\t"
  if(is.null(.dots$stringsAsFactors))
    .dots$stringsAsFactors <- FALSE
  if(is.null(.dots$na.strings))
    .dots$na.strings <- c("NA", "")
  if(is.null(.dots$strip.white))
    .dots$strip.white <- TRUE


  do.call(utils::read.table, args = .dots)
}
