% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aact_query.R
\name{aact_custom_query}
\alias{aact_custom_query}
\title{Run a custom query}
\usage{
aact_custom_query(con, query)
}
\arguments{
\item{con}{Database connection object}

\item{query}{SQL query string}
}
\value{
A data frame with the query results
}
\description{
Run a custom query
}
\examples{
\donttest{
# Set environment variables for database credentials in .Renviron and load it
# readRenviron(".Renviron")

# Connect to the database
con <- aact_connection(Sys.getenv('user'), Sys.getenv('password'))

# Run a custom query
query <- "SELECT nct_id, source, enrollment, overall_status FROM studies LIMIT 5;"
results <- aact_custom_query(con, query)

# Print the results
print(results)
}
}
