% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-getClinDT.R
\name{formatDTBarVar}
\alias{formatDTBarVar}
\title{Format a variable in a \code{\link[DT]{datatable}}
as a barplot.}
\usage{
formatDTBarVar(
  tableDT,
  data,
  barVar = NULL,
  barColorThr = NULL,
  barRange = NULL,
  getCol = function(x) x
)
}
\arguments{
\item{tableDT}{\code{\link[DT]{datatable}} object}

\item{data}{Data.frame with content of \code{tableDT}.}

\item{barVar}{Character vector with numeric variable of \code{data}
which should be represented as bar in the table.}

\item{barColorThr}{Numeric vector with threshold to 
consider to color the bar, either:
\itemize{
\item a numeric vector of length 1, same threshold for all bars
\item named vector with threshold for each bar, named with the variable
in \code{barVar}
}}

\item{barRange}{(optional) range for the bars, either:
\itemize{
\item a numeric vector of length 2, same range for all bars
\item list with range for each bar, named with the variable
in \code{barVar}
}
If not specified, the range of each \code{barVar} variable
in \code{data} is used.}

\item{getCol}{Function, which for an index of a column
in \code{data} returns the index of the column to be passed to
\code{\link[DT]{formatStyle}}}
}
\value{
Updated \code{tableDT}
}
\description{
Format a variable in a \code{\link[DT]{datatable}}
as a barplot.
}
\author{
Laure Cougnaud
}
