% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-barplotClinData.R
\name{barplotClinData}
\alias{barplotClinData}
\title{Barplot interactive plot.}
\usage{
barplotClinData(
  data,
  xVar,
  yVar,
  xLab = getLabelVar(xVar, labelVars = labelVars),
  yLab = getLabelVar(yVar, labelVars = labelVars),
  colorVar = NULL,
  colorLab = getLabelVar(colorVar, labelVars = labelVars),
  colorPalette = NULL,
  barmode = "group",
  titleExtra = NULL,
  title = paste(paste(yLab, "vs", xLab, titleExtra), collapse = "<br>"),
  labelVars = NULL,
  width = NULL,
  height = NULL,
  hoverVars,
  hoverLab,
  textVar = NULL,
  pathVar = NULL,
  pathLab = getLabelVar(pathVar, labelVars = labelVars),
  table = FALSE,
  tableVars,
  tableLab,
  tableButton = TRUE,
  tablePars = list(),
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  verbose = FALSE
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{xVar}{String with column of \code{data} containing x-variable.}

\item{yVar}{String with column of \code{data} containing y-variable.}

\item{xLab}{String with label for \code{xVar}.}

\item{yLab}{String with label for \code{xVar}.}

\item{colorVar}{(optional) String with color variable.}

\item{colorLab}{String with label for \code{colorVar}.}

\item{colorPalette}{(optional) Named character vector with color palette.
If not specified, the viridis color palette is used.\cr
See \code{\link[clinUtils]{clinColors}}.}

\item{barmode}{String with type of barplot, either:
'group' or 'stack' (see parameter in \code{\link[plotly]{layout}}).}

\item{titleExtra}{String with extra title for the plot (appended after \code{title}).}

\item{title}{String with title for the plot.}

\item{labelVars}{Named character vector containing variable labels.}

\item{width}{Numeric, width of the plot in pixels,
700 by default.}

\item{height}{Numeric, height of the plot in pixels,
700 by default.}

\item{hoverVars}{Character vector with variable(s) to be displayed in the hover,
by default any position and aesthetic variables displayed in the plot.}

\item{hoverLab}{Named character vector with labels for \code{hoverVars}.}

\item{textVar}{(optional) String with a text variable,
that will be displayed outside of each bar.}

\item{pathVar}{String with variable of \code{data} containing hyperlinks 
with path to the subject-specific report, formatted as: \cr
\preformatted{<a href="./path-to-report">label</a>}.\cr 
If multiple, they should be separated by: ', '.\cr
The report(s) will be:
\itemize{
\item{compressed to a zip file and downloaded 
if the user clicks on the 'p' (a.k.a 'profile') key
when hovering on a point of the plot}
\item{included in a collapsible row, and clickable with hyperlinks
in the table}
}}

\item{pathLab}{String with label for \code{pathVar},
included in the collapsible row in the table.}

\item{table}{Logical, if TRUE (FALSE by default)
returns also a \code{datatable} containing the plot data.
(The plot and the table are not linked.)}

\item{tableVars}{Character vector with variables to be included 
in the table.}

\item{tableLab}{Named character vector with labels
for each \code{tableVars}.}

\item{tableButton}{Logical, if TRUE (by default)
the table is included within an HTML button.}

\item{tablePars}{List with parameters passed to the
\code{\link[clinUtils]{getClinDT}} function.}

\item{id}{String with general id for the plot:
\itemize{
\item{'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}}
\item{'button:[id]' is used as button ID if \code{table} is TRUE}
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
in the current console.
For the visualizations, progress messages during download
of subject-specific report are displayed in the browser console.}
}
\value{
Either:
\itemize{
\item{if \code{table} is requested}{
a \code{clinDataReview} object, a.k.a a list with the 
'plot' (\code{\link[plotly]{plotly}} object) and 'table'
(\code{\link[DT]{datatable}} object)}
\item{otherwise: }{\code{\link[plotly]{plotly}} object}
}
}
\description{
Barplot interactive plot.
}
\examples{
library(clinUtils)

data(dataADaMCDISCP01)
labelVars <- attr(dataADaMCDISCP01, "labelVars")

dataAE <- dataADaMCDISCP01$ADAE
dataDM <- dataADaMCDISCP01$ADSL

## example of basic barplot:

# treemap takes as input table with counts
library(inTextSummaryTable)

# total counts: Safety Analysis Set (patients with start date for the first treatment)
dataTotal <- subset(dataDM, RFSTDTC != "")

# compute adverse event table
tableAE <- computeSummaryStatisticsTable(
	data = dataAE,
	rowVar = c("AEBODSYS", "AEDECOD"),
	dataTotal = dataTotal,
	labelVars = labelVars,
	stats = getStats("count")
)

dataPlot <- subset(tableAE, AEDECOD != "Total")

dataPlot$n <- as.numeric(dataPlot$n)

# create plot
barplotClinData(
	data = dataPlot,
	xVar = "AEDECOD", 
	yVar = "n", yLab = "Number of patients with adverse events",
	labelVars = labelVars
)
# add number on top of the bars
barplotClinData(
	data = dataPlot,
	xVar = "AEDECOD", 
	yVar = "n", yLab = "Number of patients with adverse events",
	textVar = "n",
	labelVars = labelVars
)

# display percentage of events per severity
tableAEBySeverity <- computeSummaryStatisticsTable(
	data = dataAE,
	rowVar = c("AEDECOD", "AESEV"),
	dataTotal = dataTotal,
	labelVars = labelVars,
	statsPerc = "statm",
	stats = getStats("\%m"),
	dataTotalPerc = dataAE,
	rowVarTotalPerc = "AEDECOD"
)
barplotClinData(
	data = tableAEBySeverity,
	xVar = "AEDECOD", 
	yVar = "statPercm", yLab = "Percentage of adverse events",
	labelVars = labelVars,
	colorVar = "AESEV", barmode = "stack",
	hoverVar = c("AEDECOD", "AESEV", "statN", "statm", "statPercm"),
	hoverLab = c(
		labelVars["AEDECOD"],
		labelVars["AESEV"],
		statN = "Number of patients",
		statm = "Number of events",
		statPercm = "Percentage of events"
	),
	textVar = "\%m",
)
}
\seealso{
Other visualizations of summary statistics for clinical data: 
\code{\link{boxplotClinData}()},
\code{\link{plotCountClinData}()},
\code{\link{sunburstClinData}()},
\code{\link{treemapClinData}()}
}
\author{
Laure Cougnaud
}
\concept{visualizations of summary statistics for clinical data}
