% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotbetas.R
\name{plotbetas}
\alias{plotbetas}
\title{Plot the model beta estimates}
\usage{
plotbetas(Dataset, plotallenv, plotall = FALSE)
}
\arguments{
\item{Dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{climatewin}}.}

\item{plotallenv}{Used in conjunction with function \code{\link{plotall}}.
Should not be changed manually.}

\item{plotall}{Used in conjunction with function \code{\link{plotall}}.
Should not be changed manually.}
}
\value{
Returns colour plots of model beta estimates. Where applicable, 2nd
  order coefficients (quadratic) and 3rd order coefficients (cubic) will be
  plotted seperately.
}
\description{
Create colour plots of model beta estimates. Will include quadratic and cubic
beta estimates where appropriate.
}
\examples{
# Plot model beta estimates for linear models in the Mass dataset

data(MassOutput)

plotbetas(Dataset = MassOutput)
}
\author{
Liam D. Bailey and Martijn van de Pol
}

