% Generated by roxygen2 (4.0.2): do not edit by hand
\name{climdex.r10mm}
\alias{climdex.r10mm}
\title{Precipitation Exceeding 10mm Per Day}
\usage{
climdex.r10mm(ci)
}
\arguments{
\item{ci}{Object of type climdexInput.}
}
\value{
A vector containing the value of the index for each year.
}
\description{
This function computes the climdex index R10mm.
}
\details{
This function takes a climdexInput object as input and computes the climdex
index R10mm: the annual count of days where daily precipitation is more than 10mm per day.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create an annual timeseries of the R10mm index.
r10mm <- climdex.r10mm(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}}, \code{\link{climdexInput.csv}}.
}
\keyword{climate}
\keyword{ts}

