% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_traversal_util.R
\name{lookForVarsAbsentInForest}
\alias{lookForVarsAbsentInForest}
\title{Look for Variable ID's that didn't occur in the Forest.}
\usage{
lookForVarsAbsentInForest(counts, vars_used, num_ind_vars, forest)
}
\arguments{
\item{counts}{A vector of split counts in the forest. This may need to be
updated with 0's for variables that didn't occur in the forest.}

\item{vars_used}{The current list of varID's that have been found in the
forest.}

\item{num_ind_vars}{The number of independent vars. Counts must have this
many elements.}

\item{forest}{Pass this to access the 'status.varID' if necessary.}
}
\value{
updated counts vector.
}
\description{
Find any remaining vars, if missing. Vars can be absent in the forest, if
they were never used to split. This function does some bookkeeping, to find
elements in the count vector that should be 0. If there weren't enough vars
observed, their indeces must be either at the end of vars_used, or the
beginning.
}

