% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_toupper}
\alias{ansi_toupper}
\alias{ansi_tolower}
\alias{ansi_chartr}
\title{ANSI character translation and case folding}
\usage{
ansi_toupper(x)

ansi_tolower(x)

ansi_chartr(old, new, x)
}
\arguments{
\item{x}{Input string. May have ANSI colors and styles.}

\item{old}{a character string specifying the characters to be
    translated.  If a character vector of length 2 or more is supplied,
    the first element is used with a warning.}

\item{new}{a character string specifying the translations. If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.}
}
\value{
Character vector of the same length as \code{x}, containing
the translated strings. ANSI styles are retained.
}
\description{
There functions are similar to \code{\link[=toupper]{toupper()}}, \code{\link[=tolower]{tolower()}} and
\code{\link[=chartr]{chartr()}}, but they keep the ANSI colors of the string.
}
\examples{
ansi_toupper(col_red("Uppercase"))

ansi_tolower(col_red("LowerCase"))

x <- paste0(col_green("MiXeD"), col_red(" cAsE 123"))
ansi_chartr("iXs", "why", x)
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_trimws}()}

Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_trimws}()}

Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
