% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{canonicalize_pairs}
\alias{canonicalize_pairs}
\title{Canonicalize element pairs}
\usage{
canonicalize_pairs(pairs, ordered = FALSE)
}
\arguments{
\item{pairs}{a matrix or data.frame of element pairs where rows correspond
to element pairs and columns correspond to element identifiers.}

\item{ordered}{whether to treat the element pairs as ordered---i.e. whether
pair \eqn{(x, y)} is distinct from pair \eqn{(y, x)} for \eqn{x \neq y}.
Defaults to FALSE, which is appropriate for clustering, undirected link
prediction, record linkage etc.}
}
\value{
Returns the element pairs in canonical form, so that:
\itemize{
\item the first element id precedes the second element id lexicographically
if \code{ordered = FALSE}---i.e. pair (3, 2) becomes pair (2, 3);
\item duplicate pairs are removed; and
\item the rows in the matrix/data.frame pairs are sorted lexicographically
by the first element id, then by the second element id.
}
}
\description{
Coerce a collection of element pairs into canonical form. Facilitates
testing of equivalence.
}
\examples{
messy_pairs <- rbind(c(2,1), c(1,2), c(3,1), c(1,2))
clean_pairs <- canonicalize_pairs(messy_pairs)
all(rbind(c(1,2), c(1,3)) == clean_pairs) # duplicates removed and order fixed

}
