#' Helps You to Code Cleaner
#'
#' Check your R code for some of the most common layout flaws.
#'
#' Many tried to teach us how to write code less dreadful, be it implicitly as
#' B. W. Kernighan and D. M. Ritchie in \cite{The C Programming Language} did,
#' be it explicitly as
#' R.C. Martin in \cite{Clean Code: A Handbook of Agile Software Craftsmanship}
#' did.
#'
#' So we should check our code for files too long or wide, functions with too
#' many lines, too wide lines, too many arguments or too many levels of nesting.
#' @note This is not a static code analyzer like pylint or the like. If you're
#' looking for a static code analyzer, check out lintr
#' (\url{https://cran.r-project.org/package=lintr} or
#' \url{https://github.com/jimhester/lintr}).
#' @seealso Packages
#' \pkg{codetools}
#' (\url{https://cran.r-project.org/package=codetools}),
#' \pkg{formatR}
#' (\url{https://cran.r-project.org/package=formatR}).
#' and
#' \pkg{lintr}
#' (\url{https://cran.r-project.org/package=lintr}).
#'
#' @author Andreas Dominik Cullmann, <adc-r@@arcor.de>
#' @name cleanr-package
#' @aliases cleanr-package
#' @docType package
#' @keywords package
NULL
