% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clgeo_SuspiciousFeatures.R
\name{clgeo_SuspiciousFeatures}
\alias{clgeo_SuspiciousFeatures}
\title{clgeo_SuspiciousFeatures}
\usage{
clgeo_SuspiciousFeatures(report, errors.only = NULL)
}
\arguments{
\item{report}{a report object as returned by\code{\link{clgeo_CollectionReport}}}

\item{errors.only}{an object of class \code{vector} giving the types of errors
for which the output should bounded. Default value is NULL (\emph{i.e.} the output
will include features for which both errors and errors were raised.). At now, this
argument only accepts the error type \code{"ORPHANED_HOLE"}.}
}
\value{
an object of class \code{vector} giving the numeric indexes of spatial
objects tagged as suspicious (\emph{i.e.} that are not valid acccording to OGC
specifications)
}
\description{
Function to get the list of index of suspicious geometries within a spatial data
collection, given a spatial data collection report returned by  the function
\code{\link{clgeo_CollectionReport}}
}
\examples{
require(maptools)
 file <- system.file("extdata", "example.shp", package = "cleangeo")
 sp <- readShapePoly(file)

 report <- clgeo_CollectionReport(sp)
 nv <- clgeo_SuspiciousFeatures(report)
}
\author{
Emmanuel Blondel \email{emmanuel.blondel1@gmail.com}
}
\seealso{
\code{\link{clgeo_CollectionReport}}
}
\keyword{geometry}
\keyword{validity}

