/*
 * Decompiled with CFR 0.152.
 */
package edu.richmond.nlp;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CoreMap;

public class CSVDependencyDocumentWriter {
    public String docID = "";
    public String header = "";

    public CSVDependencyDocumentWriter(String docID) {
        this.docID = docID;
        this.header = String.format("id,sid,tid,tid_target,relation,relation_full%n", new Object[0]);
    }

    public String print(CoreMap sentence) {
        StringBuilder sb = new StringBuilder();
        SemanticGraph enhancedDependencies = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class);
        if (enhancedDependencies != null) {
            for (IndexedWord root : enhancedDependencies.getRoots()) {
                String rel = GrammaticalRelation.ROOT.getLongName();
                rel = rel.replaceAll("\\s+", "");
                sb.append(String.format("%s,%d,%d,%d,%s,%s%n", this.docID, root.sentIndex(), 0, root.index(), rel, rel));
            }
            for (SemanticGraphEdge edge : enhancedDependencies.edgeListSorted()) {
                GrammaticalRelation reln = edge.getRelation();
                String relnName = reln == null ? "" : reln.toString();
                String relnNameBasic = relnName.split(":", -1)[0];
                sb.append(String.format("%s,%d,%d,%d,%s,%s%n", this.docID, edge.getSource().sentIndex(), edge.getSource().index(), edge.getTarget().index(), relnNameBasic, relnName));
            }
        }
        return sb.toString();
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }
}

