\name{ggClassPred}
\alias{ggClassPred}
\title{
Barplot of the per class accuracies.
}
\description{
The \code{ggClasPred} function generates a barplot with the per class accuracies (\%) for all the correctly classified and misclassified samples in the classification ensemble.
}
\usage{
ggClassPred(ensObj, position = "stack", displayAll = FALSE, showText = FALSE, 
            xlabel = NULL, ylabel = NULL, cbPalette = FALSE, fillBrewer = FALSE)
}
\arguments{
  \item{ensObj}{The classification ensemble (in the form of an R list) as generated by \code{\link{cfBuild}}}
  \item{position}{The position may be equal to either "stack" or "dodge".}
  \item{displayAll}{Boolean value, by default set to \code{FALSE}. When \code{displayAll= FALSE}, only the percentages of correctly classified samples are displayed in the barplot. If \code{displayAll = TRUE}, the percentages of all classified and missclassified samples are depicted in the barplot.}
  \item{showText}{Boolean value, by default set to \code{FALSE}. If \code{showText=TRUE}, then the per class accuracies (\%) for all classifiers in the ensemble are displayed in the plot.}
  \item{xlabel}{A sub title for the x axis (optional field).}
  \item{ylabel}{A sub title for the y axis (optional field).}
  \item{cbPalette}{If TRUE, enable a color-blind-friendly palette.}
  \item{fillBrewer}{If TRUE, enable a color scale taken from the RColorBrewer package.}
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]
            
ens <- cfBuild(irisData, irisClass, bootNum = 100, ensNum = 100, parallel = TRUE, 
               cpus = 4, type = "SOCK")

# Show the percentages of correctly classified samples in 
# a barplot with or without text respectively

ggClassPred(ens)
ggClassPred(ens, showText = TRUE)

# Show the percentages of classified and missclassified samples
# in a barplot simultaneously with and without text

ggClassPred(ens, displayAll = TRUE)
ggClassPred(ens, position="stack", displayAll = TRUE)
ggClassPred(ens, position="stack", displayAll = TRUE, showText = TRUE)

# Alernatively, using a dodge position
ggClassPred(ens, position = "dodge", displayAll = TRUE)
ggClassPred(ens, position = "dodge", displayAll = TRUE, showText = TRUE)
}
}
\keyword{hplot}