% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarkeTest.R
\name{indivLogLiks}
\alias{indivLogLiks}
\alias{indivLogLiks.glm}
\alias{indivLogLiks.lm}
\alias{indivLogLiks.polr}
\alias{indivLogLiks.clm}
\alias{indivLogLiks.multinom}
\alias{indivLogLiks.negbin}
\title{Calculate individual log-likelihood values}
\usage{
indivLogLiks(model)

\method{indivLogLiks}{glm}(model)

\method{indivLogLiks}{lm}(model)

\method{indivLogLiks}{polr}(model)

\method{indivLogLiks}{clm}(model)

\method{indivLogLiks}{multinom}(model)

\method{indivLogLiks}{negbin}(model)
}
\arguments{
\item{model}{A statistical model object.}
}
\value{
A vector of individual log-likelihood values for the model.
}
\description{
Calculate individual log-likelihood values
}
\details{
The \code{indivLogLiks} function calls
the appropriate method for calculating individual
log likelihood values for the model.  The function
currently supports binomial, poisson and negative
binomial GLMs, ordinal models estimated with either
\code{polr} from the \code{MASS} package
or \code{clm} from the \code{ordinal}
package and multinomial models estimated with either
\code{multinom} from the \code{nnet}
package.  Users can also write new
methods for both \code{indivLogLiks} and \code{nparams}
that would get called by the generic function.

For the purposes of the \code{clarke_test} function, the \code{indivLogLiks}
functions are not intended to be called directly by the user.
}
