% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/user_followee_count.R
\name{user_followee_count}
\alias{user_followee_count}
\title{Return a a user's follower count}
\usage{
user_followee_count(id, url = get_default_url(), as = "list", ...)
}
\arguments{
\item{id}{(character) User identifier.}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Return a a user's follower count
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org/", key = getOption("ckan_demo_key"))

# list package activity
user_followee_count('sckottie')

# input a ckan_user object
(x <- user_show('sckottie'))
user_followee_count(x)

# output different data formats
user_followee_count(x, as = "table")
user_followee_count(x, as = "json")
}
}

