% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scripts.R
\name{fetch_output_file_ids}
\alias{fetch_output_file_ids}
\alias{fetch_output}
\title{Return output from a civis_script.}
\usage{
fetch_output_file_ids(x, regex = NULL)

fetch_output(x, regex = NULL)
}
\arguments{
\item{x}{civis_script}

\item{regex}{string, regex used to match the run output name.}
}
\value{
A named list of run output file ids with names matching \code{regex}.
}
\description{
Return output from a civis_script.
}
\details{
If the script has no outputs, the results are a list of length is 0.
}
\section{Functions}{
\itemize{
\item \code{fetch_output()}: Return output of \code{scripts_list_*_runs_outputs} matching \code{regex}.

}}
\examples{
\dontrun{
out <- fetch_output(civis_script(1234))

# Filter output with regex, then read into memory:
ids <- fetch_output_file_ids(civis_script(1234), regex = '.csv')
vals <- lapply(ids, read_civis, using = read.csv)
}
}
\seealso{
Other script_utils: 
\code{\link{civis_script}()},
\code{\link{run_civis}()},
\code{\link{run_template}()}

Other script_utils: 
\code{\link{civis_script}()},
\code{\link{run_civis}()},
\code{\link{run_template}()}
}
\concept{script_utils}
