% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{search_list_queries}
\alias{search_list_queries}
\title{Search queries that are not hidden}
\usage{
search_list_queries(
  search_string = NULL,
  database_id = NULL,
  credential_id = NULL,
  author_id = NULL,
  archived = NULL,
  state = NULL,
  started_before = NULL,
  started_after = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{search_string}{string optional. Space delimited search terms for searching queries by their SQL. Supports wild card characters "?" for any single character, and "*" for zero or more characters.}

\item{database_id}{integer optional. The database ID.}

\item{credential_id}{integer optional. The credential ID.}

\item{author_id}{integer optional. The author of the query.}

\item{archived}{boolean optional. The archival status of the requested item(s). Defaults to false.}

\item{state}{array optional. The state of the last run. One or more of queued, running, succeeded, failed, and cancelled.}

\item{started_before}{string optional. An upper bound for the start date of the last run.}

\item{started_after}{string optional. A lower bound for the start date of the last run.}

\item{limit}{integer optional. Number of results to return. Defaults to 10. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to last_run_started_at. Must be one of: last_run_started_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The query ID.}
\item{database}{integer, The database ID.}
\item{credential}{integer, The credential ID.}
\item{sql}{string, The SQL executed by the query.}
\item{authorId}{integer, The author of the query.}
\item{archived}{boolean, The archival status of the requested item(s).}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, The state of the run. One of queued, running, succeeded, failed, and cancelled.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
}
\description{
Search queries that are not hidden
}
