% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_list_kubernetes_deployments}
\alias{clusters_list_kubernetes_deployments}
\title{List the deployments associated with a Kubernetes Cluster}
\usage{
clusters_list_kubernetes_deployments(
  id,
  base_type = NULL,
  state = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{id}{integer required. The id of the cluster.}

\item{base_type}{string optional. If specified, return deployments of these base types. It accepts a comma-separated list, possible values are 'Notebook', 'Service', 'Run'.}

\item{state}{string optional. If specified, return deployments in these states. It accepts a comma-separated list, possible values are pending, running, terminated, sleeping}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to created_at. Must be one of: created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The id of this deployment.}
\item{name}{string, The name of the deployment.}
\item{baseId}{integer, The id of the base object associated with the deployment.}
\item{baseType}{string, The base type of this deployment.}
\item{state}{string, The state of the deployment.}
\item{cpu}{integer, The CPU in millicores required by the deployment.}
\item{memory}{integer, The memory in MB required by the deployment.}
\item{diskSpace}{integer, The disk space in GB required by the deployment.}
\item{instanceType}{string, The EC2 instance type requested for the deployment.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, }
\item{updatedAt}{string, }
}
\description{
List the deployments associated with a Kubernetes Cluster
}
