% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civis_future.R
\name{CivisFuture}
\alias{CivisFuture}
\alias{run.CivisFuture}
\alias{result.CivisFuture}
\alias{cancel.CivisFuture}
\alias{resolved.CivisFuture}
\alias{fetch_logs.CivisFuture}
\title{Evaluate an expression in Civis Platform}
\usage{
CivisFuture(
  expr = NULL,
  envir = parent.frame(),
  substitute = FALSE,
  globals = TRUE,
  packages = NULL,
  lazy = FALSE,
  local = TRUE,
  gc = FALSE,
  earlySignal = FALSE,
  label = NULL,
  required_resources = list(cpu = 1024, memory = 2048, diskSpace = 4),
  docker_image_name = "civisanalytics/datascience-r",
  docker_image_tag = "3",
  ...
)

\method{run}{CivisFuture}(future, ...)

\method{result}{CivisFuture}(future, ...)

\method{cancel}{CivisFuture}(future, ...)

\method{resolved}{CivisFuture}(future, ...)

\method{fetch_logs}{CivisFuture}(object, ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[future]{future}()}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{lazy}{If \code{FALSE} (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done to the global environment of the \R process
evaluating the future.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{required_resources}{resources, see \code{\link{scripts_post_containers}}}

\item{docker_image_name}{the image for the container script.}

\item{docker_image_tag}{the tag for the Docker image.}

\item{...}{arguments to \code{\link{scripts_post_containers}}}

\item{future}{CivisFuture object.}

\item{object}{CivisFuture}
}
\value{
A \code{CivisFuture} inheriting from \code{\link{Future}} that evaluates \code{expr} on the given container.
}
\description{
Evaluate an expression in Civis Platform
}
\section{Methods (by generic)}{
\itemize{
\item \code{run}: Run a CivisFuture

\item \code{result}: Return the value of a CivisFuture

\item \code{cancel}: Cancel a CivisFuture

\item \code{resolved}: Check if a CivisFutre has resolved

\item \code{fetch_logs}: Fetch logs from a CivisFuture
}}

