% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_post}
\alias{scripts_post}
\title{Create a script}
\usage{
scripts_post(name, remote_host_id, credential_id, sql, params = NULL,
  arguments = NULL, template_script_id = NULL, notifications = NULL,
  hidden = NULL)
}
\arguments{
\item{name}{string required. The name of the script.}

\item{remote_host_id}{integer required. The database ID.}

\item{credential_id}{integer required. The credential ID.}

\item{sql}{string required. The raw SQL query for the script.}

\item{params}{array optional. An array containing the following fields: 
\itemize{
\item name string, The variable's name as used within your code.
\item label string, The label to present to users when asking them for the value.
\item description string, A short sentence or fragment describing this parameter to the end user.
\item type string, The type of parameter. Valid options: string, multi_line_string, integer, float, bool, file, table, database, credential_aws, credential_redshift, or credential_custom
\item required boolean, Whether this param is required.
\item value string, The value you would like to set this param to. Setting this value makes this parameter a fixed param.
\item default string, If an argument for this parameter is not defined, it will use this default value. Use true, True, t, y, yes, or 1 for true bool's or false, False, f, n, no, or 0 for false bool's. Cannot be used for parameters that are required or a credential type.
\item allowedValues array, The possible values this parameter can take, effectively making this an enumerable parameter. Allowed values is an array of hashes of the following format: `{label: 'Import', 'value': 'import'}`
}}

\item{arguments}{list optional. Parameter-value pairs to use when running this script. Only settable if this script has defined parameters.}

\item{template_script_id}{integer optional. The ID of the template script, if any.  A script cannot both have a template script and be a template for other scripts.}

\item{notifications}{list optional. A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}

\item{hidden}{boolean optional. The hidden status of the item.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the script.}
\item{name}{string, The name of the script.}
\item{type}{string, The type of the script (e.g SQL, Container, Python, R, JavaScript)}
\item{createdAt}{string, The time this script was created.}
\item{updatedAt}{string, The time the script was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the script's last run.}
\item{finishedAt}{string, The time that the script's last run finished.}
\item{category}{string, The category of the script.}
\item{projects}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID for the project.
\item name string, The name of the project.
}}
\item{parentId}{integer, The ID of the parent job that will trigger this script}
\item{userContext}{string, "runner" or "author", who to execute the script as when run as a template.}
\item{params}{array, An array containing the following fields: 
\itemize{
\item name string, The variable's name as used within your code.
\item label string, The label to present to users when asking them for the value.
\item description string, A short sentence or fragment describing this parameter to the end user.
\item type string, The type of parameter. Valid options: string, multi_line_string, integer, float, bool, file, table, database, credential_aws, credential_redshift, or credential_custom
\item required boolean, Whether this param is required.
\item value string, The value you would like to set this param to. Setting this value makes this parameter a fixed param.
\item default string, If an argument for this parameter is not defined, it will use this default value. Use true, True, t, y, yes, or 1 for true bool's or false, False, f, n, no, or 0 for false bool's. Cannot be used for parameters that are required or a credential type.
\item allowedValues array, The possible values this parameter can take, effectively making this an enumerable parameter. Allowed values is an array of hashes of the following format: `{label: 'Import', 'value': 'import'}`
}}
\item{arguments}{list, Parameter-value pairs to use when running this script. Only settable if this script has defined parameters.}
\item{isTemplate}{boolean, Whether others scripts use this one as a template.}
\item{publishedAsTemplateId}{integer, The ID of the template that this script is backing.}
\item{fromTemplateId}{integer, The ID of the template this script uses, if any.}
\item{templateDependentsCount}{integer, How many other scripts use this one as a template.}
\item{templateScriptName}{string, The name of the template script.}
\item{links}{list, A list containing the following elements: 
\itemize{
\item details string, The details link to get more information about the script.
\item runs string, The runs link to get the run information list for this script.
}}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{nextRunAt}{string, The time of the next scheduled run.}
\item{timeZone}{string, The time zone of this script.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{hidden}{boolean, The hidden status of the item.}
\item{targetProjectId}{integer, Target project to which script outputs will be added.}
\item{archived}{string, The archival status of the requested item(s).}
\item{templateScriptId}{integer, The ID of the template script, if any.}
}
\description{
Create a script
}
