% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{predictions_patch}
\alias{predictions_patch}
\title{Update a prediction}
\usage{
predictions_patch(id, output_table_name = NULL, limiting_sql = NULL,
  primary_key = NULL)
}
\arguments{
\item{id}{integer required. The ID of the prediction.}

\item{output_table_name}{string optional. The name of the output table for this prediction.}

\item{limiting_sql}{string optional. A SQL WHERE clause used to scope the rows to be predicted.}

\item{primary_key}{array optional. The primary key or composite keys of the table being predicted.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the prediction.}
\item{modelId}{integer, The ID of the model used for this prediction.}
\item{scoredTableId}{integer, The ID of the source table for this prediction.}
\item{scoredTableName}{string, The name of the source table for this prediction.}
\item{outputTableName}{string, The name of the output table for this prediction.}
\item{state}{string, The state of the last run of this prediction.}
\item{error}{string, The error, if any, of the last run of this prediction.}
\item{startedAt}{string, The start time of the last run of this prediction.}
\item{finishedAt}{string, The end time of the last run of this prediction.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{scoredTables}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of the table with created predictions.
\item schema string, The schema of table with created predictions.
\item name string, The name of table with created predictions.
\item createdAt string, The time when the table with created predictions was created.
\item scoreStats array, An array of metrics on the created predictions.
}}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday.
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour.
}}
\item{limitingSQL}{string, A SQL WHERE clause used to scope the rows to be predicted.}
\item{primaryKey}{array, The primary key or composite keys of the table being predicted.}
}
\description{
Update a prediction
}
