% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{apps_patch_instances}
\alias{apps_patch_instances}
\title{Update a given app instance}
\usage{
apps_patch_instances(id, slug, name = NULL)
}
\arguments{
\item{id}{integer required. The unique id of the instance.}

\item{slug}{string required. The slug for the application.}

\item{name}{string optional. The name of the instance.}
}
\value{
A list containing the following elements:
\item{id}{integer, The unique id of the instance.}
\item{name}{string, The name of the instance.}
\item{appReleaseId}{integer, The id of the app release the instance belongs to.}
\item{reportId}{integer, The id of the report the instance belongs to.}
\item{createdAt}{string, The time the instance was created at.}
\item{user}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{projectId}{integer, The id of the project collecting all the objects that belong to this app instance.}
\item{authCodeUrl}{string, }
\item{apiKey}{string, A Civis API key that can be used by this app instance.}
}
\description{
Update a given app instance
}
