% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_list_kubernetes}
\alias{clusters_list_kubernetes}
\title{List Kubernetes Clusters}
\usage{
clusters_list_kubernetes(organization_slug = NULL, limit = NULL,
  page_num = NULL, order = NULL, order_dir = NULL)
}
\arguments{
\item{organization_slug}{string optional. The slug of this cluster's organization.}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to organization_id. Must be one of: organization_id, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of this cluster.}
\item{instanceType}{string, The EC2 instance types in this cluster.}
\item{minInstances}{integer, The minimum number of instances in this cluster.}
\item{maxInstances}{integer, The maximum number of instances in this cluster.}
\item{instanceMaxMemory}{integer, The amount of memory available to a single instance.}
\item{instanceMaxCpu}{integer, The number of processor shares available to a single instance.}
\item{organizationId}{string, The id of this cluster's organization.}
\item{organizationSlug}{string, The slug of this cluster's organization.}
\item{securityGroupId}{string, The security group to be added to the nodes of this cluster}
}
\description{
List Kubernetes Clusters
}
