% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_civis}
\alias{write_civis}
\alias{write_civis.data.frame}
\alias{write_civis.character}
\title{Upload a local data frame or csv file to the Civis Platform (Redshift)}
\usage{
write_civis(x, ...)

\method{write_civis}{data.frame}(x, tablename, database = NULL,
  if_exists = "fail", distkey = NULL, sortkey1 = NULL, sortkey2 = NULL,
  max_errors = NULL, verbose = FALSE, ...)

\method{write_civis}{character}(x, tablename, database = NULL,
  if_exists = "fail", distkey = NULL, sortkey1 = NULL, sortkey2 = NULL,
  max_errors = NULL, verbose = FALSE, ...)
}
\arguments{
\item{x}{data frame or file path of csv to upload to platform.}

\item{...}{arguments passed to \code{write.csv}.}

\item{tablename}{string, Name of table and schema \code{"schema.tablename"}.}

\item{database}{string, Name of database where data frame is to be uploaded. If no database is specified,
uses \code{options(civis.default_db)}.}

\item{if_exists}{string, optional,  String indicating action to take if table already
exists.  Must be either "fail", "truncate" or "append". Defaults to "fail".}

\item{distkey}{string, optional, Column name designating the distkey.}

\item{sortkey1}{string, optional, Column name designating the first sortkey.}

\item{sortkey2}{string, optional, Column name designating the second
(compound) sortkey.}

\item{max_errors}{int, optional, Maximum number of rows with errors
to remove before failing.}

\item{verbose}{bool, Set to TRUE to print intermediate progress indicators.}
}
\description{
Uploads either a data frame or csv file to Redshift, based
on the first argument.

A default database can be set using \code{options(civis.default_db = "my_database")}.
If there is only one database available,
this database will automatically be used as the default.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Upload a data frame to Civis Platform (Redshift).

\item \code{character}: Upload a csv to Civis Platform (Redshift).
}}

\examples{
\dontrun{
df <- read.csv(local_file)

# Create new table, fail if already exists
write_civis(df, "schema.my_table", "my_database")

# Create new table, append if already exists
write_civis(df, "schema.my_table", "my_database", if_exists="append")

# Create new table with defined diskey / sortkeys for speed!
write_civis(df, "schema.my_table", "my_database", distkey="id",
            sortkey1="added_date")

# Create new table directly from a saved csv
write_civis("my/file/path.csv", "schema.my_table", "my_database")

}
}
\seealso{
\code{\link{refresh_table}} to update table meta-data.

Other io: \code{\link{download_civis}},
  \code{\link{query_civis}}, \code{\link{read_civis}},
  \code{\link{write_civis_file}}
}
