% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-driver.R, R/dbi-connection.R,
%   R/dbi-result.R
\docType{class}
\name{DBI}
\alias{DBI}
\alias{CivisDriver-class}
\alias{show,CivisDriver-method}
\alias{dbConnect,CivisDriver-method}
\alias{dbDataType,CivisDriver,ANY-method}
\alias{dbDataType,CivisDriver,list-method}
\alias{dbIsValid,CivisDriver-method}
\alias{dbGetInfo,CivisDriver-method}
\alias{CivisConnection-class}
\alias{show,CivisConnection-method}
\alias{dbIsValid,CivisConnection-method}
\alias{dbIsReadOnly,CivisConnection-method}
\alias{dbDisconnect,CivisConnection-method}
\alias{dbSendQuery,CivisConnection,character-method}
\alias{dbSendStatement,CivisConnection,character-method}
\alias{dbDataType,CivisConnection,ANY-method}
\alias{dbQuoteString,CivisConnection,character-method}
\alias{dbQuoteIdentifier,CivisConnection,character-method}
\alias{dbWriteTable,CivisConnection,character,data.frame-method}
\alias{dbReadTable,CivisConnection,character-method}
\alias{dbListTables,CivisConnection-method}
\alias{dbExistsTable,CivisConnection,character-method}
\alias{dbListFields,CivisConnection,character-method}
\alias{dbRemoveTable,CivisConnection,character-method}
\alias{dbGetInfo,CivisConnection-method}
\alias{dbBegin,CivisConnection-method}
\alias{dbCommit,CivisConnection-method}
\alias{dbRollback,CivisConnection-method}
\alias{CivisResult-class}
\alias{show,CivisResult-method}
\alias{dbClearResult,CivisResult-method}
\alias{dbFetch,CivisResult-method}
\alias{dbHasCompleted,CivisResult-method}
\alias{dbGetInfo,CivisResult-method}
\alias{dbIsValid,CivisResult-method}
\alias{dbGetStatement,CivisResult-method}
\alias{dbColumnInfo,CivisResult-method}
\alias{dbGetRowCount,CivisResult-method}
\alias{dbGetRowsAffected,CivisResult-method}
\alias{dbBind,CivisResult-method}
\title{DBI methods}
\usage{
\S4method{show}{CivisDriver}(object)

\S4method{dbConnect}{CivisDriver}(drv, database, ...)

\S4method{dbDataType}{CivisDriver,ANY}(dbObj, obj, ...)

\S4method{dbDataType}{CivisDriver,list}(dbObj, obj, ...)

\S4method{dbIsValid}{CivisDriver}(dbObj, ...)

\S4method{dbGetInfo}{CivisDriver}(dbObj, ...)

\S4method{show}{CivisConnection}(object)

\S4method{dbIsValid}{CivisConnection}(dbObj, ...)

\S4method{dbIsReadOnly}{CivisConnection}(dbObj, ...)

\S4method{dbDisconnect}{CivisConnection}(conn, ...)

\S4method{dbSendQuery}{CivisConnection,character}(conn, statement, ...)

\S4method{dbSendStatement}{CivisConnection,character}(conn, statement, ...)

\S4method{dbDataType}{CivisConnection,ANY}(dbObj, obj, ...)

\S4method{dbQuoteString}{CivisConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{CivisConnection,character}(conn, x, ...)

\S4method{dbWriteTable}{CivisConnection,character,data.frame}(conn, name, value,
  overwrite = FALSE, append = FALSE, ...)

\S4method{dbReadTable}{CivisConnection,character}(conn, name, ...)

\S4method{dbListTables}{CivisConnection}(conn, ...)

\S4method{dbExistsTable}{CivisConnection,character}(conn, name, ...)

\S4method{dbListFields}{CivisConnection,character}(conn, name, ...)

\S4method{dbRemoveTable}{CivisConnection,character}(conn, name, ...)

\S4method{dbGetInfo}{CivisConnection}(dbObj, ...)

\S4method{dbBegin}{CivisConnection}(conn, ...)

\S4method{dbCommit}{CivisConnection}(conn, ...)

\S4method{dbRollback}{CivisConnection}(conn, ...)

\S4method{show}{CivisResult}(object)

\S4method{dbClearResult}{CivisResult}(res, ...)

\S4method{dbFetch}{CivisResult}(res, n = -1, ...)

\S4method{dbHasCompleted}{CivisResult}(res, ...)

\S4method{dbGetInfo}{CivisResult}(dbObj, ...)

\S4method{dbIsValid}{CivisResult}(dbObj, ...)

\S4method{dbGetStatement}{CivisResult}(res, ...)

\S4method{dbColumnInfo}{CivisResult}(res, ...)

\S4method{dbGetRowCount}{CivisResult}(res, ...)

\S4method{dbGetRowsAffected}{CivisResult}(res, ...)

\S4method{dbBind}{CivisResult}(res, params, ...)
}
\arguments{
\item{object}{Any R object}

\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{database}{The name of a database on the Civis Platform.}

\item{...}{authentication arguments needed by the DBMS instance; these
typically include \code{user}, \code{password}, \code{host}, \code{port}, \code{dbname}, etc.
For details see the appropriate \code{DBIDriver}.}

\item{dbObj}{A object inheriting from \linkS4class{DBIDriver}
or \linkS4class{DBIConnection}}

\item{obj}{An R object whose SQL type we want to determine.}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{x}{A character vector to quote as string.}

\item{name}{A character string specifying the unquoted DBMS table name,
or the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{overwrite}{Allow overwriting the destination table. Cannot be
`TRUE` if `append` is also `TRUE`.}

\item{append}{Allow appending to the destination table. Cannot be
`TRUE` if `overwrite` is also `TRUE`.}

\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{params}{A list of bindings, named or unnamed.}
}
\description{
Implementations of pure virtual functions defined in the `DBI` package.
}
