% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_analysis.R
\name{ssm_parameters}
\alias{ssm_parameters}
\title{Calculate Structural Summary Method parameters for a set of scores}
\usage{
ssm_parameters(
  scores,
  angles = octants(),
  prefix = "",
  suffix = "",
  e_label = "Elev",
  x_label = "Xval",
  y_label = "Yval",
  a_label = "Ampl",
  d_label = "Disp",
  f_label = "Fit"
)
}
\arguments{
\item{scores}{Required. A numeric vector (or single row data frame)
containing one score for each of a set of circumplex scales.}

\item{angles}{Required. A numeric vector containing the angular displacement
of each circumplex scale included in \code{scores} (in degrees).}

\item{prefix}{Optional. A string to append to the beginning of all of the SSM
parameters' variable names (default = "").}

\item{suffix}{Optional. A string to append to the end of all of the SSM
parameters' variable names (default = "").}

\item{e_label}{Optional. A string representing the variable name of the SSM
elevation parameter (default = "Elev").}

\item{x_label}{Optional. A string representing the variable name of the SSM
x-value parameter (default = "Xval").}

\item{y_label}{Optional. A string representing the variable name of the SSM
y-value parameter (default = "Yval").}

\item{a_label}{Optional. A string representing the variable name of the SSM
amplitude parameter (default = "Ampl").}

\item{d_label}{Optional. A string representing the variable name of the SSM
displacement parameter (default = "Disp").}

\item{f_label}{Optional. A string representing the variable name of the SSM
fit or R-squared value (default = "Fit").}
}
\value{
A data frame containing the SSM parameters calculated from \code{scores}.
}
\description{
Calculate SSM parameters (without confidence intervals) for a set of scores
and generate a data frame with customizable labels for each parameter value.
This function requires the input to be a numeric vector (or coercable to one)
and returns only the parameters. See \code{\link{ssm_score}()} for a similar
function that calculates SSM parameters for each row of a data frame.
}
\examples{
# Manually enter octant scores
scores <- c(0.55, 0.58, 0.62, 0.76, 1.21, 1.21, 1.48, 0.90)
ssm_parameters(scores)

# Customize several of the labels
ssm_parameters(scores, x_label = "LOV", y_label = "DOM")

# Add a prefix to all labels
ssm_parameters(scores, prefix = "IIP_")

}
\seealso{
Other ssm functions: 
\code{\link{ssm_analyze}()},
\code{\link{ssm_score}()},
\code{\link{ssm_table}()}

Other analysis functions: 
\code{\link{ssm_analyze}()},
\code{\link{ssm_score}()}
}
\concept{analysis functions}
\concept{ssm functions}
