% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circumplex.R
\docType{package}
\name{circumplex-package}
\alias{circumplex}
\alias{circumplex-package}
\title{Analysis and visualization of circumplex data}
\description{
circumplex provides functions for analyzing and visualizing circumplex data.
}
\details{
Its goal is to unify, modernize, and extend existing methods of working with
circumplex data. Its functions share an underlying design philosophy and
grammar. The three guiding principles it aspires to are:

\itemize{
\item \strong{Accessibility:} zero cost, open source, libre; works on many
platforms; easy to use across skill levels
\item \strong{Flexibility:} customizable by the user; extendable for other uses;
plays nicely with other packages
\item \strong{Consistency:} unit-tested quality control; firm naming conventions;
data flows between functions
}

To learn more about circumplex, start with the vignettes:
\code{browseVignettes(package = "circumplex")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/jmgirard/circumplex}
  \item Report bugs at \url{https://github.com/jmgirard/circumplex/issues}
}

}
\author{
\strong{Maintainer}: Jeffrey Girard \email{me@jmgirard.com} (0000-0002-7359-3746)

Authors:
\itemize{
  \item Johannes Zimmermann (0000-0001-6975-2356)
  \item Aidan Wright (0000-0002-2369-0601)
}

}
