### R code from vignette source 'circular_phylogenetic_tree.Rnw'

###################################################
### code chunk number 1: circular_phylogenetic_tree.Rnw:34-41 (eval = FALSE)
###################################################
## library(ape)
## data(bird.orders)
## hc = as.hclust(bird.orders)
## labels = hc$labels
## ct = cutree(hc, 6)  # cut tree into 6 pieces
## n = length(labels)  # number of bird species
## hc = as.dendrogram(hc)


###################################################
### code chunk number 2: circular_phylogenetic_tree.Rnw:99-112 (eval = FALSE)
###################################################
## library(circlize)
## par(mar = c(1, 1, 1, 1))
## circos.par(cell.padding = c(0, 0, 0, 0))
## circos.initialize("a", xlim = c(0, n))
## maxy = attr(hc, "height")  # maximum height of the tree
## circos.trackPlotRegion(ylim = c(0, 1), bg.border = NA, track.height = 0.3, 
##     panel.fun = function(x, y) {
##         for(i in seq_len(n)) {
##             circos.text(i-0.5, 0, labels[i], adj = c(0, 0.5), 
##                 facing = "clockwise", niceFacing = TRUE,
##                 col = ct[labels[i]], cex = 0.7)
##         }
## })


###################################################
### code chunk number 3: circular_phylogenetic_tree.Rnw:120-167 (eval = FALSE)
###################################################
## # -dend a `dendogram` object
## # -maxy the maximum height of the tree is a global attribute,
## #       so here it is set as an argument
## circos.dendrogram = function(dend, maxy=attr(dend, "height")) {
##     labels = as.character(labels(dend))
##     x = seq_along(labels) - 0.5 # leaves are places at x = 0.5, 1.5, ..., n - 0.5
##     names(x) = labels
##     
##     is.leaf = function(object) (is.logical(L = attr(object, "leaf"))) && L
##     
##     draw.d = function(dend, maxy) {
##         leaf = attr(dend, "leaf")
##         d1 = dend[[1]]  # child tree 1
##         d2 = dend[[2]]  # child tree 2
##         height = attr(dend, 'height')
##         midpoint = attr(dend, 'midpoint')
##         
##         if(is.leaf(d1)) {
##             x1 = x[as.character(attr(d1, "label"))]
##         } else {
##             x1 = attr(d1, "midpoint") + x[as.character(labels(d1))[1]]
##         }
##         y1 = attr(d1, "height")
##         
##         if(is.leaf(d2)) {
##             x2 = x[as.character(attr(d2, "label"))]
##         } else {
##             x2 = attr(d2, "midpoint") + x[as.character(labels(d2))[1]]
##         }
##         y2 = attr(d2, "height")
##         
##         # plot the connection line
##         circos.lines(c(x1, x1), maxy - c(y1, height), straight = TRUE)
##         circos.lines(c(x1, x2), maxy - c(height, height))
##         circos.lines(c(x2, x2), maxy - c(y2, height), straight = TRUE)
##         
##         # do it recursively
##         if(!is.leaf(d1)) {
##             draw.d(d1, maxy)
##         }
##         if(!is.leaf(d2)) {
##             draw.d(d2, maxy)
##         }
##     }
##     
##     draw.d(dend, maxy)
## }


###################################################
### code chunk number 4: circular_phylogenetic_tree.Rnw:172-178 (eval = FALSE)
###################################################
## circos.trackPlotRegion(ylim = c(0, maxy), bg.border = NA, 
##     track.height = 0.4, panel.fun = function(x, y) {
##         circos.dendrogram(hc, maxy)
## })
## 
## circos.clear()


