% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use-circle-deploy.R
\name{use_circle_deploy}
\alias{use_circle_deploy}
\title{Set Up Build Deployment Between Circle CI And Github}
\usage{
use_circle_deploy(
  repo = github_info()$name,
  user = github_info()$owner$login,
  quiet = FALSE
)
}
\arguments{
\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}

\item{quiet}{\verb{[logical]}\cr
If \code{TRUE}, console output is suppressed.}
}
\value{
No return value, called for side effects.
}
\description{
Creates a Circle CI "user-key" (= SSH key pair) if none exists
yet to enable deployment from Circle CI builds to GitHub.
}
\details{
The easiest way to achieve a deployment from Circle CI builds to a Github
repo is by creating a so called "user-key" (i.e. an SSH key pair) on
Circle CI.

\code{use_circle_deploy()} tries to be smart by exiting early if such a key is
already present.

If the repo has not been enabled yet on Circle CI, please run \code{enable_repo()}
first.
Also to be able to authenticate to Github in the first place a personal
access token needs to be set (via env var \code{GITHUB_TOKEN}).
\code{usethis::github_token()} can be used to check if one is already set.
If none is set, this function will prompt you to create one.
}
\examples{
\dontrun{
use_circle_deploy()
}
}
