% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circacompare.R
\name{circacompare}
\alias{circacompare}
\title{circacompare}
\usage{
circacompare(
  x,
  col_time,
  col_group,
  col_outcome,
  period = 24,
  alpha_threshold = 0.05,
  timeout_n = 10000,
  control = list()
)
}
\arguments{
\item{x}{data.frame.  This is the data.frame which contains the rhythmic data for two groups in a tidy format.}

\item{col_time}{The name of the column within the data.frame, x, which contains time in hours at which the data were collected.}

\item{col_group}{The name of the column within the data.frame, x, which contains the grouping variable.  This should only have two levels.}

\item{col_outcome}{The name of the column within the data.frame, x, which contains outcome measure of interest.}

\item{period}{The period of the rhythm. For circadian rhythms, leave this as the default value, 24.}

\item{alpha_threshold}{The level of alpha for which the presence of rhythmicity is considered. Default is 0.05.}

\item{timeout_n}{The upper limit for the model fitting attempts. Default is 10,000.}

\item{control}{\code{list}. Used to control the parameterization of the model.}
}
\value{
list
}
\description{
\code{circacompare} performs a comparison between two rhythmic groups of data. It tests for rhythmicity and then fits a nonlinear model with parametrization to estimate and statistically support differences in mesor, amplitude, and phase between groups.
}
\examples{
df <- make_data(phi1 = 6)
out <- circacompare(x = df, col_time = "time", col_group = "group",
                    col_outcome = "measure")
out
}
