% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_surf.R
\name{resample_surf}
\alias{resample_surf}
\title{Resample a \code{"surf"} object}
\usage{
resample_surf(
  surf,
  resamp_res,
  hemisphere = c("left", "right"),
  wb_path = NULL
)
}
\arguments{
\item{surf}{A \code{"surf"} object}

\item{resamp_res}{The desired resolution}

\item{hemisphere}{\code{"left"} or \code{"right"}. Only used if not indicated by 
\code{surf$hemisphere}. An error will be raised if it does not match the 
hemisphere indicated in the intermediate written GIFTI.}

\item{wb_path}{(Optional) Path to Connectome Workbench folder or executable. 
If not provided, should be set with 
\code{ciftiTools.setOption("wb_path", "path/to/workbench")}.}
}
\value{
The new surface
}
\description{
Resample a \code{"surf"} object by writing it to a GIFTI, using the Connectome
 Workbench to resample it, and then reading the new file.
}
