% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-subset.R
\docType{methods}
\name{[[,RasterArray,ANY,ANY-method}
\alias{[[,RasterArray,ANY,ANY-method}
\title{Indexing to extract RasterLayers of a RasterArray object}
\usage{
\S4method{[[}{RasterArray,ANY,ANY}(x, i, drop = TRUE)
}
\arguments{
\item{x}{\code{RasterArray} object.}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{drop}{\code{logical} should the \code{RasterStack} be dropped and the element be reduced to a single \code{RasterLayer}?}
}
\value{
A \code{RasterLayer} or \code{RasterArray} class object.
}
\description{
Double bracket \code{'[['} refers to layers' name in the \code{RasterStack} of the \code{RasterArray}. Use single brackets to extract elements based on their position in the \code{RasterArray}.
}
\examples{
data(dems)
# finds a layer
dems[["dem_30"]]
# returns a stack
dems[[c("dem_0", "dem_15")]]
# replaces a layervalues, but not the attributes of the layer
dem2 <- dems
dem2[["dem_0"]] <- dem2[["dem_5"]]
# compare every value in the 0 and 5 ma maps, they are all the same
mean(values(dem2[["dem_0"]]==dem2[["dem_5"]]))
}
