% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronicle.R
\name{print.chronicle}
\alias{print.chronicle}
\title{Print method for chronicle objects.}
\usage{
\method{print}{chronicle}(x, ...)
}
\arguments{
\item{x}{A chronicle object.}

\item{...}{Unused.}
}
\value{
No return value, called for side effects (printing the object on screen).
}
\description{
Print method for chronicle objects.
}
\details{
`chronicle` object are, at their core, lists with the following elements:
* "$value": a an object of type `maybe` containing the result of the computation (see the "Maybe monad" vignette for more details on `maybe`s).
* "$log_df": a `data.frame` object containing the printed object’s log information.

`print.chronicle()` prints the object on screen and shows:
* the value using its `print()` method (for example, if the value is a data.frame, `print.data.frame()` will be used)
* a message indicating to the user how to recuperate the value inside the `chronicle` object and how to read the object’s log
}
