% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df_state_demographics}
\alias{df_state_demographics}
\title{A data.frame containing demographic statistics for each state plus the District of Columbia.}
\usage{
data(df_state_demographics)
}
\description{
A data.frame containing demographic statistics for each state plus the District of Columbia.
}
\examples{
\dontrun{
library(choroplethr)
data(df_state_demographics)

# examine the 2013, 5-year state percent hispanic estimates as a boxplot and choropleth

# the boxplot shows the distribution
boxplot(df_state_demographics$percent_hispanic)

# the choropleth map shows the location of the values
# first set the 'value' column to be the column we want to render
df_state_demographics$value = df_state_demographics$percent_hispanic
state_choropleth(df_state_demographics)
}
}
\references{
Data comes from the 2013 5-year American Community Survey (ACS). Data generated by
?get_state_demographics.
}
\keyword{data}
