% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeSeries.R
\name{plot.time_series}
\alias{plot.time_series}
\title{Plot aggregate time series data from Vestry report.}
\usage{
\method{plot}{time_series}(x, statistic = "fatal.attacks",
  pump.handle = TRUE, main = "Removal of the Broad Street Pump Handle",
  type = "o", xlab = "Date", ylab = "Fatalities", ...)
}
\arguments{
\item{x}{An object of class "time_series" from timeSeries().}

\item{statistic}{Character. Fatality measure: either "fatal.attacks" or "deaths".}

\item{pump.handle}{Logical. Indicate date of removal of Broad Street pump handle.}

\item{main}{Character. Title of graph.}

\item{type}{Character. R plot type.}

\item{xlab}{Character. x-axis label.}

\item{ylab}{Character. y-axis label.}

\item{...}{Additional plotting parameters.}
}
\description{
Plot aggregate fatality data and indicates the date of the removal of the handle of the Broad Street pump.
}
\examples{
plot(timeSeries())
plot(timeSeries(), statistic = "deaths")
plot(timeSeries(), bty = "n", type = "h", lwd = 4)
}
\seealso{
\code{\link{timeSeries}}
}
