% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhood.R
\name{addNeighborhood}
\alias{addNeighborhood}
\title{Add expected walking neighborhoods.}
\usage{
addNeighborhood(pump.subset = NULL, pump.select = NULL,
  vestry = FALSE, weighted = TRUE, multi.core = FALSE, area = TRUE,
  path = NULL, path.color = NULL, path.width = 3,
  alpha.level = 0.25, ...)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to subset from the neighborhoods defined by \code{pump.select}. Negative selection possible. \code{NULL} uses all pumps in \code{pump.select}.}

\item{pump.select}{Numeric. Numeric vector of pump IDs that define which pump neighborhoods to consider (i.e., specify the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest path weighted by road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. On Windows, only \code{multi.core = FALSE} is available.}

\item{area}{Logical. Area polygons.}

\item{path}{Character. "expected" or "observed".}

\item{path.color}{Character. Use a single color for all paths. \code{NULL} uses neighborhood colors defined by \code{snowColors()}.}

\item{path.width}{Numeric. Set width of paths.}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{...}{Additional plotting parameters.}
}
\description{
Add expected walking neighborhoods.
}
\note{
This function is computationally intensive. On a single core of a 2.3 GHz Intel i7, plotting observed paths to PDF takes about 5 seconds while doing so for expected paths takes about 28 seconds. Using the parallel implementation on 4 physical (8 logical) cores, these times fall to about 4 and 11 seconds. Note that parallelization is currently only available on Linux and Mac, and that although some precautions are taken in R.app on macOS, the developers of the 'parallel' package, which \code{neighborhoodWalking()} uses, strongly discourage against using parallelization within a GUI or embedded environment. See \code{vignette("parallel")} for details.
}
\examples{
\dontrun{

streetNameLocator("marshall street", zoom = TRUE, highlight = FALSE,
  unit = "meter", cases = NULL)
addNeighborhood(6:7)

}
}
\seealso{
\code{\link{snowMap}},
\code{\link{addIndexCase}},
\code{\link{addKernelDensity}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addVoronoi}},
\code{\link{addWhitehead}}
}
