% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeSeries.R
\name{timeSeries}
\alias{timeSeries}
\title{Aggregate time series fatality data from the Vestry report.}
\usage{
timeSeries(vestry = FALSE)
}
\arguments{
\item{vestry}{Logical. TRUE returns the data from the Vestry committee (Appendix B, p. 175). FALSE (default) returns John Snow's contribution to the report (p.117).}
}
\value{
A R list with two objects: "data" and "source" ("snow" or "vestry").
\itemize{
  \item{\code{date}: Calendar date.}
  \item{\code{day}: Day of the week.}
  \item{\code{deaths}: Measure of fatality.}
  \item{\code{fatal.attacks}: Measure of fatality.}
}
}
\description{
Aggregate time series fatality data from the Vestry report.
}
\section{Note}{
 The "snow" data appears on p. 117 of the report; the "vestry" data appear in Appendix B on p.175.
}

\examples{
timeSeries(vestr = TRUE)
plot(timeSeries())
}
\seealso{
\code{\link{plot.time_series}}, \code{\link{print.time_series}}, \code{vignette("time.series")}
}
