% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sketch.R
\name{Sketch}
\alias{Sketch}
\title{Sketch}
\usage{
Sketch(Data, W, ind.col = 1:ncol(Data), ncores = 1, parallel = FALSE)
}
\arguments{
\item{Data}{A Filebacked Big Matrix n x N. Data signals are stored in the matrix columns.}

\item{W}{A frequency matrix m x n. The frequency vectors are stored in the matrix rows.}

\item{ind.col}{Column indeces for which the data sketch is computed. By default all matrix columns.}

\item{ncores}{Number of used cores. By default 1. If \code{parallel} = FALSE, ncores defines a number of data splits
on which the sketch is computed separatelly.}

\item{parallel}{logical parameter that indicates whether computations are performed on several cores in parallel or not.}
}
\value{
The data sketch vector.
}
\description{
The data sketch computation.
}
\details{
The sketch of the given data collection \eqn{x_1, \dots, x_N} is a vector of the length 2m.
First m components of the data sketch vector correspond to its real part, \emph{i.e.} \eqn{\frac{1}{N} \sum_{i=1}^N \cos(W x_i)}.
Last m components are its imaginary part, \emph{i.e.} \eqn{\frac{1}{N} \sum_{i=1}^N \sin(W x_i)}.
}
\examples{
X = matrix(rnorm(1000), ncol=100, nrow = 10)
X_FBM = bigstatsr::FBM(init = X, ncol=100, nrow = 10)
W = GenerateFrequencies(Data = X_FBM, m = 20, N0 = 100, TypeDist = "AR")$W
SK1 = Sketch(X_FBM, W)
SK2 = Sketch(X_FBM, W, parallel = TRUE, ncores = 2)
all.equal(SK1, SK2)
}
\references{
\insertRef{DBLP:journals/corr/KerivenBGP16}{chickn}.
}
