% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmg01.R
\docType{data}
\name{kmg01_main}
\alias{kmg01_main}
\alias{kmg01_pre}
\alias{kmg01}
\title{\code{KMG01} Kaplan-Meier Plot 1.}
\format{
An object of class \code{chevron_g} of length 1.
}
\usage{
kmg01_main(
  adam_db,
  dataset = "adtte",
  arm_var = "ARM",
  strata = NULL,
  strat = lifecycle::deprecated(),
  ...
)

kmg01_pre(adam_db, dataset = "adtte", ...)

kmg01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{strata}{(\code{character}) the variable name of stratification variables.}

\item{strat}{(\code{character}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; for backwards compatibility only.
Use \code{strata} instead.}

\item{...}{Further arguments passed to \code{g_km} and \code{control_coxph}. For details, see
the documentation in \code{tern}.
Commonly used arguments include \code{col}, \code{pval_method}, \code{ties}, \code{conf_level}, \code{conf_type},
\code{annot_coxph}, \code{annot_stats}, etc.}
}
\value{
the main function returns a \code{gTree} object.

a \code{gTree} object.

the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
\code{KMG01} Kaplan-Meier Plot 1.
}
\details{
\itemize{
\item No overall value.
}
}
\section{Functions}{
\itemize{
\item \code{kmg01_main()}: Main TLG Function

\item \code{kmg01_pre()}: Preprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain the table specified by \code{dataset} with the columns specified by  \code{arm_var}.
}
}
\examples{
library(dplyr)
library(dunlin)

col <- c(
  "A: Drug X" = "black",
  "B: Placebo" = "blue",
  "C: Combination" = "gray"
)

pre_data <- log_filter(syn_data, PARAMCD == "OS", "adtte")
run(kmg01, pre_data, dataset = "adtte", col = col)
}
\keyword{datasets}
