% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcDivProf.R
\name{calcDivProf}
\alias{calcDivProf}
\title{Calculate a diversity profile}
\usage{
calcDivProf(
  sampleData,
  compDisMat = NULL,
  type = "HillDiv",
  qMin = 0,
  qMax = 3,
  step = 0.1
)
}
\arguments{
\item{sampleData}{Data frame with the relative concentration of each
compound (column) in every sample (row).}

\item{compDisMat}{Compound distance matrix, as calculated by
\code{\link{compDis}}. Has to be supplied for calculations of
Functional Hill diversity.}

\item{type}{Type of Hill Diversity to calculate for the diversity profile.
\code{"HillDiv"} or \code{"FuncHillDiv"}.}

\item{qMin}{Minimum value of \emph{q}.}

\item{qMax}{Maximum value of \emph{q}.}

\item{step}{Increment by which \emph{q} will be calculated between \code{qMin}
and \code{qMax}.}
}
\value{
List with a diversity profile data frame with samples as rows
and the Hill diversity or Functional Hill diversity for different \emph{q}
values as columns; and values for \code{type}, \code{qMin},
\code{qMax} and \code{step}.
}
\description{
Function to calculate a diversity profile, i.e. calculate Hill diversity
or Functional Hill Diversity for a range of \emph{q} values.
}
\details{
The function calculates a diversity profile for each sample
in \code{sampleData}. A diversity profile is a calculation of
Hill Diversity or Functional Hill Diversity for a range of
different values of \emph{q}. This function performs the calculations,
while \code{\link{chemoDivPlot}} can be used to conveniently
create the diversity profile plot, where Hill Diversity is
plotted as a function of \emph{q} within the chosen range.
The shape of the diversity profile curve reflects the evenness
of compound proportions in the sample. For a perfectly even sample
the curve is flat. The more uneven the compound proportions are,
the more steep is the decline of the curve. A common range,
used as default, of \emph{q} values is between \code{qMin = 0} and
\code{qMax = 3}, as diversity should change little beyond \code{qMax = 3}.
See \code{\link{calcDiv}} for further details on \emph{q}.
}
\examples{
data(minimalSampData)
data(minimalCompDis)
calcDivProf(sampleData = minimalSampData)
calcDivProf(sampleData = minimalSampData, compDisMat = minimalCompDis,
type = "FuncHillDiv")

data(alpinaCompData)
data(alpinaCompDis)
calcDivProf(sampleData = alpinaSampData, compDisMat = alpinaCompDis,
type = "FuncHillDiv", qMin = 1, qMax = 2, step = 0.2)
}
\references{
Chao A, Chiu C-H, Jost L. 2014. Unifying Species Diversity,
Phylogenetic Diversity, Functional Diversity, and Related Similarity and
Differentiation Measures Through Hill Numbers.
Annual Review of Ecology, Evolution, and Systematics 45: 297-324.
}
