% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_presaved_attribution.r
\docType{data}
\name{ames_rf_pred}
\alias{ames_rf_pred}
\alias{ames_rf_shap}
\title{Ames random forest model predictions and shap values}
\format{
\code{ames_rf_pred} is a n=338 length vector of the prediction of an
random forest model predicting the numeric House Sales in North Ames.
\code{ames_rf_shap} is a (338 x 9) data frame of the treeshap SHAP attribution of
the random forest model for each observation.

\strong{Replicating}

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(cheem)
library(randomForest)
library(treeshap)

## Regression setup
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Model and treeSHAP
ames_rf_fit <- randomForest::randomForest(
  X, Y, ntree = 125,
  mtry = ifelse(is_discrete(Y), sqrt(ncol(X)), ncol(X) / 3),
  nodesize = max(ifelse(is_discrete(Y), 1, 5), nrow(X) / 500))
ames_rf_pred <- predict(ames_rf_fit, X)
ames_rf_shap <- treeshap::treeshap(
  treeshap::randomForest.unify(ames_rf_fit, X), X, FALSE, FALSE)
ames_rf_shap <- ames_rf_shap$shaps

if(F)\{ ## Don't accidentally save
  save(ames_rf_pred, file = "./data/ames_rf_pred.rda")
  save(ames_rf_shap, file = "./data/ames_rf_shap.rda")
  #usethis::use_data(ames_rf_pred)
  #usethis::use_data(ames_rf_shap)
\}
}\if{html}{\out{</div>}}

An object of class \code{data.frame} with 338 rows and 9 columns.
}
\usage{
ames_rf_pred

ames_rf_shap
}
\description{
Predictions and treeshap attribution of a random forest model of North Ames
house sales data regressing Sales Price from house and lot variables.
}
\examples{
library(cheem)

## Regression setup
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Precomputed predictions and shap attribution
str(ames_rf_pred)
str(ames_rf_shap)

## Cheem
ames_chm <- cheem_ls(X, Y, ames_rf_shap, ames_rf_pred, clas,
                     label = "Ames, random forest, treeshap")

## Save for use with shiny app (expects an rds file)
if(FALSE){ ## Don't accidentally save.
  saveRDS(ames_chm, "./ames_rf_tshap.rds")
  run_app() ## Select the saved rds file from the data dropdown.
}

## Cheem visuals
if(interactive()){
  prim <- 1
  comp <- 2
  global_view(ames_chm, primary_obs = prim, comparison_obs = comp)
  bas <- sug_basis(ames_rf_shap, prim, comp)
  mv  <- sug_manip_var(ames_rf_shap, primary_obs = 1, comparison_obs = 2)
  ggt <- radial_cheem_tour(ames_chm, basis = bas, manip_var = mv)
  animate_plotly(ggt)
}
}
\keyword{datasets}
