% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersection.R
\name{check_intersection}
\alias{check_intersection}
\title{Check Atomic Vector Intersection}
\usage{
check_intersection(x, y, all_y = FALSE, x_name = substitute(x),
  y_name = substitute(y), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{y}{The second atomic vector.}

\item{all_y}{A flag indicating whether all the elements in y should have a match in x.}

\item{x_name}{A string of the name of the object x.}

\item{y_name}{A string of the name of the object y.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks that all the elements in atomic vector x intersect with those in atomic vector y.
}
\examples{
x1 <- 1:3
x2 <- 1:4
check_intersection(x1, x2)
check_intersection(x2, x1, error = FALSE)
}
\seealso{
\code{\link{check_join}}
}
