% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability.R
\name{check_probability}
\alias{check_probability}
\title{Check Probability}
\usage{
check_probability(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce an integer to numeric.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a probability (non-missing double scalar between 0 and 1 inclusive or if \code{coerce = TRUE} an integer of 0 or 1).
}
\examples{
check_probability(1, error = FALSE)
check_probability(1.1, error = FALSE)
check_probability(c(0, 1), error = FALSE)
}
\seealso{
\code{\link{check_number}} and \code{\link{check_scalar}}
}
