% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern.R
\name{check_pattern}
\alias{check_pattern}
\title{Check Pattern}
\usage{
check_pattern(x, pattern, all = TRUE, x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{pattern}{A string of the regular expression.}

\item{all}{A flag indicating whether all or some of the element must match pattern.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether all or some of the elements of x match pattern using \code{\link{grepl}}.
}
\examples{
check_pattern("b ", "b", error = FALSE)
check_pattern("b ", "^b$", error = FALSE)
}
