% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanRepoPackages.R
\name{scanForPackages}
\alias{scanForPackages}
\title{Scans a project (or folder) for references to packages.}
\usage{
scanForPackages(project = getwd(), verbose = TRUE, use.knitr = FALSE,
  auto.install.knitr = FALSE, scan.rnw.with.knitr = FALSE)
}
\arguments{
\item{project}{A project path.  This is the path to the root of the project that references the packages to be installed from the MRAN snapshot for the date specified for \code{snapshotDate}.  Defaults to current working directory using \code{\link[=getwd]{getwd()}}.}

\item{verbose}{If \code{TRUE}, displays progress messages.}

\item{use.knitr}{If \code{TRUE},  parses all \code{Rmarkdown} files using the \code{knitr} package.}

\item{auto.install.knitr}{If \code{TRUE} and the project contains rmarkdown files, then automatically included the packages \code{knitr} in packages to install.}

\item{scan.rnw.with.knitr}{If \code{TRUE}, uses \code{\link[knitr:knit]{knitr::knit()}} to parse \code{.Rnw} files, otherwise use \code{\link[utils:Sweave]{utils::Sweave()}}}
}
\value{
A list with two elements:
\itemize{
\item pkgs: a character vector with the names of identified packages
\item error: a character vector with information about files that could not be parsed
}
}
\description{
Scans a project (or folder) for references to packages.
}
